***********************************************************************
*
* darts uevent.asm -- Version 3.0 
*
* Copyright (c)
* Steven E. Glass and Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements the 
* main event loop used by the program.
*
***********************************************************************

               case on

               copy 2/ainclude/e16.types
               copy 2/ainclude/e16.event
               copy 2/ainclude/e16.window
               copy darts.equ

               mcopy macros/uevent.macros

               longi on
               longa on

***********************************************************************
*
* doScore
*
* This procedure does all the scoring in this program.  It is only
* called when the user presses a button that has a non-zero low word
* for an ID.
*
* How the scoring works depends on the game being played.  There is a
* section for scoring each of the games.
*
doScore        start

               DefineStack

otherPlayer    word
playerHits     word
otherHits      word

saveDPage      word
returnAddr     word

amount         word
playerNum      word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for locals.
               pha
               pha
               tsc                      ;Set directPage register.
               tcd

               lda gameType             ;Which game?
               bne crickett

               lda playerNum            ;Simple add to score for Robin.
               asl a
               tay
               lda score,y
               adc amount
               sta score,y

               pei playerNum            ;Add it the the list.
               pei amount
               jsr addToList
               pei playerNum
               jsr invalScore           ;Update the score.
               brl exit

crickett       lda playerNum
               eor #1
               sta otherPlayer

               pei playerNum            ;How many hits for this player.
               pei amount
               jsr getCTval
               sta playerHits
               pei otherPlayer          ;And how many for other.
               pei amount
               jsr getCTval
               sta otherHits

               cmp #3                   ;See if either is still open.
               bcc atLeastOneOpen
               lda playerHits
               cmp #3
               bcs neitherOpen

atLeastOneOpen pei playerNum            ;Increment player hit value.
               pei amount
               jsr getCTval
               inc a
               sta playerHits
               sta crickettTables,y

               pei playerNum            ;Change the hit indicator for button.
               pei amount
               jsr fixButtonTitle

               lda playerHits           ;See if we can count this one.
               cmp #3+1
               bcc noCount
               lda otherHits
               cmp #3
               bcs noCount

               lda playerNum            ;It counts -- add it in.
               asl a
               tay
               lda score,y
               adc amount
               sta score,y
               pei playerNum
               jsr invalScore

noCount        pei playerNum            ;Add it to list -- score or no score.
               pei amount
               jsr addToList

neitherOpen    lda weHaveAWinner        ;Make sure we don't already have winner.
               bne alreadyHaveWinner

               ldx #15                  ;Scan the relavent button to see that
aa             pei playerNum            ;this player has them all closed.
               phx
               jsr getCTval
               cmp #3
               bcc aaz                  ;Here is an open one -- carry clear.
               inx
               cpx #21
               bcc aa
               php
               ldx #25
               plp
               beq aa                   ;Fall out if all closed -- carry set.
aaz            bcc stillOneOpen
               lda playerNum
               asl a
               tay
               lda otherPlayer
               asl a
               tax
               lda score,y              ;player's score
               cmp score,x              ;other player's score
               bcc noWinnerYet          ;Only if are all closed, and this
*                                       ;player is ahead.

               inc weHaveAWinner        ;Bingo.

               PushLong theWindow
               _BeginUpdate
               jsl drawThisWindow
               PushLong theWindow
               _EndUpdate

               pea refIsResource*2
               PushLong #0
               PushLong #3
               _AlertWindow

alreadyHaveWinner anop
stillOneOpen   anop
noWinnerYet    anop
exit           anop
               pla                      ;Remove local variable space.
               pla
               pla
               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               pla
               phx                      ;Restore return address and return.
               rts

               end




* INPUTS:         playerNum & amount -- on stack.
* OUTPUTS:        YREG:    index into crickettTables
*                 ACC:     value at crickettTables[index]
*                 XREG:    preserved.
*
getCTval       start

               lda 5,s                  ;playerNum (0 or 1)
               asl a                    ;*2
               adc 5,s                  ;*3
               asl a                    ;*6
               asl a                    ;*12
               adc 5,s                  ;*13
               asl a                    ;*26
               asl a                    ;*52
               adc 3,s                  ;amount
               adc 3,s                  ;elements are words
               sta 5,s                  ;index

               pla                      ;return address
               ply                      ;amount
               ply                      ;index
               pha
               lda crickettTables,y     ;crickettTables value
               rts

               end

***********************************************************************
*
* doControls
*
* This procedure is called by mainEvent whenever taskmaster
* returns inControl.
*
doControls     start

               DefineStack

whichButton    word
buttonNum      word
lastItem       word
playerNum      word

saveDPage      word
returnAddr     word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for locals.
               pha
               pha
               pha
               tsc                      ;Set directPage register.
               tcd

               ldx #Player1             ;Assume Player1

               lda event+owmTaskData4
               beq loWordZero

               bpl aa
               ldx #Player2             ;Assumption wrong.

aa             stx playerNum
               and #$7FFF
               sta whichButton

               pei playerNum
               pha                      ;whichButton
               jsr doScore
               bra exit

loWordZero     lda event+owmTaskData4+2
               cmp #1
               bcc noCase
               bne notCase1

case1          pha                      ;Result space.
               pea refIsResource*2
               PushLong #0
               PushLong #ConfirmTextID
               _AlertWindow
               pla
               cmp #1
               bne exit
               jsr doQuitItem
               bra exit

case2          jsr doNewItem            ;Inits current window for new game.
               bra exit

notCase1       ldx #Player1
               cmp #3
               bcc case2
               beq case3

case4          ldx #Player2
case3          lda event+owmClickCount
               cmp #2
               bcc exit
               stz event+owmClickCount
               phx                      ;Which player
               jsr removeSelected       ;Delete selected items from list.

noCase         anop
exit           pla                      ;Remove local variable space.
               pla
               pla
               pla
               pld                      ;Restore directPage register.
               rts

               end



disableItems   start
               pea NewItem
               _DisableMItem
               pea QuitItem
               _DisableMItem
               pea AboutItem
               _DisableMItem
               rts

               end


enableItems    start
               pea NewItem
               _EnableMItem
               pea QuitItem
               _EnableMItem
               pea AboutItem
               _EnableMItem
               rts

               end

***********************************************************************
*
* checkFrontW
*
* This routine adjusts the system menu bar depending on what window is
* selected.  It activates the edit menu if a desk accessory is opened
* and selected.  It deactivates the edit menu if the game window
* becomes active again.
*
* We do this because it makes no sense to have progam menus active when
* a desk accessory is active and there is no sense having the edit menu
* active when this program does not use it.
*
* It is called every time through the event loop.  The global variable
* lastWindow helps us from making lots of checks if nothing has changed.
*
checkFrontW    start

******************

               pha                      ;Get top window.
               pha
               _FrontWindow
               pla
               plx

               cmp lastWindow           ;Is it the same as last time?
               bne notSameWind
               cpx lastWindow+2
               bne notSameWind
               brl sameWind             ;Yes, do nothing.

notSameWind    sta lastWindow           ;New 'last' window.
               stx lastWindow+2

               ora lastWindow+2
               bne thereIsOne           ;Make sure that we have one.

noWindow       pea $80                  ;We don't.
               pea EditMenuID
               _SetMenuFlag
               _DrawMenuBar
               jsr disableItems
               bra exit

thereIsOne     pha                      ;Check for DA's.
               PushLong lastWindow
               _GetSysWFlag
               pla
               beq notSysWind

               jsr disableItems         ;Make menus correct for DA's.
               pea $FF7F
               pea EditMenuID
               _SetMenuFlag
               pea $80
               pea GameMenuID
               _SetMenuFlag
               _DrawMenuBar
               jmp exit

notSysWind     pea $80                  ;Make menus correct for us.
               pea EditMenuID
               _SetMenuFlag
               pea $FF7F
               pea GameMenuID
               _SetMenuFlag
               _DrawMenuBar
               jsr enableItems

sameWind       anop
exit           anop
               rts

               end

***********************************************************************
*
* mainEvent
*
* This is the main routine in the program.  It continuously calls
* taskmaster and handles any events that occur.  It also keeps the
* right menus active by calling checkFrontW.
*
mainEvent      start

               DefineStack

code           word
checkFirstUpdate word

saveDPage      word
returnAddr     word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for locals.
               pha
               tsc                      ;Set directPage register.
               tcd

               stz quitFlag
               lda #1
               sta checkFirstUpdate
               stz lastWindow
               stz lastWindow+2

loopLongAndHard jsr checkFrontW         ;Loop almost forever.
               pha
               pea $FFFF
               PushLong #event
               _TaskMaster
               pla

               cmp #wInSpecial
               beq menuCase
               cmp #wInMenuBar
               bne aa

menuCase       jsr doMenu
               bra next

aa             cmp #wInControl
               bne default
               jsr doControls
               bra next

default        lda checkFirstUpdate
               beq next
               lda firstUpdateComplete
               beq next
               _InitCursor
               stz checkFirstUpdate

next           lda quitFlag
               beq loopLongAndHard

               pla                      ;Remove local variable space.
               pla
               pld                      ;Restore directPage register.
               rts

               end

               END
